/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.block.IPetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.xplat.IXplatAbstractions;

public class BlockAltar
extends BlockMod
implements EntityBlock {
    public static final EnumProperty<IPetalApothecary.State> FLUID = EnumProperty.m_61587_((String)"fluid", IPetalApothecary.State.class);
    private static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape MIDDLE = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private static final VoxelShape TOP = Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
    private static final VoxelShape TOP_CUTOUT = Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)20.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)MIDDLE), (VoxelShape)Shapes.m_83113_((VoxelShape)TOP, (VoxelShape)TOP_CUTOUT, (BooleanOp)BooleanOp.f_82685_));
    public final Variant variant;

    protected BlockAltar(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FLUID, (Comparable)((Object)IPetalApothecary.State.EMPTY)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FLUID});
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            TileAltar tile = (TileAltar)world.m_7702_(pos);
            if (tile.collideEntityItem(itemEntity)) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileAltar tile = (TileAltar)world.m_7702_(pos);
        IPetalApothecary.State fluid = tile.getFluid();
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            InventoryHelper.withdrawFromInventory(tile, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            return InteractionResult.SUCCESS;
        }
        if (tile.isEmpty() && fluid == IPetalApothecary.State.WATER && stack.m_41619_()) {
            tile.trySetLastRecipe(player);
            return InteractionResult.SUCCESS;
        }
        if (this.tryWithdrawFluid(player, hand, tile) || this.tryDepositFluid(player, hand, tile)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (world.f_46441_.nextInt(20) == 1 && state.m_61143_(FLUID) == IPetalApothecary.State.EMPTY) {
            world.m_46597_(pos, (BlockState)state.m_61124_(FLUID, (Comparable)((Object)IPetalApothecary.State.WATER)));
        }
    }

    private boolean tryWithdrawFluid(Player player, InteractionHand hand, TileAltar altar) {
        Fluid fluid = altar.getFluid().asVanilla();
        if (fluid == Fluids.f_76191_ || fluid == Fluids.f_76193_ && IXplatAbstractions.INSTANCE.gogLoaded()) {
            return false;
        }
        boolean success = IXplatAbstractions.INSTANCE.insertFluidIntoPlayerItem(player, hand, fluid);
        if (success) {
            altar.setFluid(IPetalApothecary.State.EMPTY);
        }
        return success;
    }

    private boolean tryDepositFluid(Player player, InteractionHand hand, TileAltar altar) {
        if (altar.getFluid() != IPetalApothecary.State.EMPTY) {
            return false;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_150930_(ModItems.waterRod) && ManaItemHandler.instance().requestManaExact(stack, player, 75, false)) {
            ManaItemHandler.instance().requestManaExact(stack, player, 75, true);
            altar.setFluid(IPetalApothecary.State.WATER);
            return true;
        }
        if (IXplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (Fluid)Fluids.f_76193_)) {
            altar.setFluid(IPetalApothecary.State.WATER);
            return true;
        }
        if (IXplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (Fluid)Fluids.f_76195_)) {
            altar.setFluid(IPetalApothecary.State.LAVA);
            return true;
        }
        return false;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileAltar(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return BlockAltar.createTickerHelper(type, ModTiles.ALTAR, TileAltar::clientTick);
        }
        return BlockAltar.createTickerHelper(type, ModTiles.ALTAR, TileAltar::serverTick);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof TileSimpleInventory) {
                TileSimpleInventory inventory = (TileSimpleInventory)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return state.m_61143_(FLUID) == IPetalApothecary.State.WATER ? 15 : 0;
    }

    public static enum Variant {
        DEFAULT,
        FOREST,
        PLAINS,
        MOUNTAIN,
        FUNGAL,
        SWAMP,
        DESERT,
        TAIGA,
        MESA,
        MOSSY;

    }
}

